require( "scripts/style.lua" );

kButtonSpacing  = 60;
kButtonY 		= kCenter-70;


--- get radio options.
options = PrepareRadioOptions(gLevel);


radio_ids    = {};
radio_labels = {};
radio_images_norm = {};
radio_images_over = {};
for i = 1, options, 1 do
	vCurRadioId 	 = GetRadioId(i) + 1;
	radio_ids[i]	     = vCurRadioId - 1;
	radio_labels[i]      = "radio_" .. vCurRadioId;
	radio_images_norm[i] = "radioicons/radio_icon.png";
	radio_images_over[i] = "radioicons/radio_over.png";
end

if (options < 2) then
	-- there is no radio id 2
	radio_ids[2] = 100;
end;

StandardButtonFont2 = {
  standardFont,
  24,
  BlackColor
};
RadioStationIconFont = {
	standardFont,
	18,
	BlackColor
};
FontRadioTutorial = {
	standardFont,
	16,
	BlackColor
};
DecorButtonGraphics1 = {
	radio_images_norm[1], -- up
	radio_images_norm[1], -- down
	radio_images_over[1], -- over
};
DecorButtonStyle1 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = DecorButtonGraphics1,
};
DecorButtonGraphics2 = {
	radio_images_norm[2], -- up
	radio_images_norm[2], -- down
	radio_images_over[2], -- over
};
DecorButtonStyle2 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = DecorButtonGraphics2,
};


--DebugOut("I've been called******************");
--DebugOut("options:"..options);


------ define Y-alignment positions -------
graphicElementsY = kButtonY + 30;
textElementsY    = graphicElementsY + 150 ;
---------------------------------------------------


------ define X-alignment positions -------
element1posX = kCenter + 10 - 120;
element2posX = kCenter + 10 + 120;
---------------------------------------------------

vCanClick  = true;
vClickDone = false;

MakeDialog
{
	RadioStationWindow
	{
		x   		= kCenter,
		y   		= kCenter,
		fit 		= true,
		fadeSpeed	= 1.75;
		w			= 800,
		h 			= 600,
		
		Bitmap
		{
			-- BACKGROUND IMAGE ---------------------------------------------------------------
			name 	= "radios",
			image	= "backgrounds/upgrades_background",
			x		= kCenter,
			y		= kCenter - 20, --+ (kButtonSpacing * 1),
		},
			
		-- TITLE -----------------------------------------------------------------------------------
		SetStyle(ButtonStyle),
		Text
		{
			x		= kCenter,
			y		= kButtonY - 140,
			w		= 300,
			h		= 100,
			flags 	= kVAlignCenter + kHAlignCenter,
			label 	= "radio_upgrades_title",
			font    = TitleUpgradesFont,
		},
		
		-- Message 1 --------------------------------------------------------------------
		SetStyle(ButtonStyle),
		Text
		{
			x 		= kCenter,
			y 		= graphicElementsY - 110,
			w		= 460,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			label   = "radio_window_top_message",
			font	= StandardButtonFont2,
		},
		
		-- RADIO UPGRADE  IMAGE (((1))) ------------------------------------------
		SetStyle(DecorButtonStyle1),
		Button
		{
			x				= element2posX,
			y				= graphicElementsY-65,
			name			= "radioStationButton1",
			command 		= function()
								if ( vClickDone == false ) then
									vClickDone = true;
									SelectRadioStation( radio_ids[1] );
									FadeOutAndClose();
								end
							  end
		},	
		
		Text
		{
			x 		= element2posX,
			y 		= graphicElementsY - 15,
			w		= 200,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			label   = "radio_" .. (radio_ids[1] + 1),
			font	= RadioStationIconFont,
		},
		
		Text
		{
			x 		= element2posX,
			y 		= graphicElementsY + 5,
			w		= 200,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			label   = "radio_genre_" .. (radio_ids[1] + 1),
			font	= RadioStationIconFont,
		},
		
		-- DECORATION UPGRADE  IMAGE (((2))) --------------------------------------------
		SetStyle(DecorButtonStyle2),		
		Button
		{
			x				= element2posX,
			y 				= graphicElementsY+65,
			name			= "radioStationButton2",
			command 		= function()
								if ( vClickDone == false ) then
									vClickDone = true;
									SelectRadioStation( radio_ids[2] );
									FadeOutAndClose();
								end
							  end
		},
		
		Text
		{
			x 		= element2posX,
			y 		= graphicElementsY + 70 + 45,
			w		= 200,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			label   = "radio_" .. (radio_ids[2] + 1),
			font	= RadioStationIconFont,
		},
		
		Text
		{
			x 		= element2posX,
			y 		= graphicElementsY + 90 +45,
			w		= 200,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			label   = "radio_genre_" .. (radio_ids[2] + 1),
			font	= RadioStationIconFont,
		},
		
		-- GENERIC TEXT ((((1))))------------------------------------------------------
		SetStyle(ButtonStyle),
		Text
		{
			x 		= kCenter,
			y 		= textElementsY+43,
			w		= 460,
			h		= 80,
			flags 	= kVAlignCenter + kHAlignCenter,
			name	= "generictext1";
			label   = "radio_window_bottom_message",
			font	= StandardButtonFont2,
		},
		
		Bitmap
		{
			name  = "instr_img_1",
			image = "radioicons/radioarrow.png",
			x 	  = 180,
			y     = 185,
		},
		
		
		SetStyle(ButtonStyle),
		Text
		{
			x 		= 196,
			y 		= 275,
			w		= 214,
			h		= 125,
			flags 	= kVAlignCenter + kHAlignCenter,
			name	= "text_radio_tutorial";
			label   = "radio_window_text_radio",
			font	= FontRadioTutorial,
		},
		
	},
}

GameInPauseDialog(false, false);

